<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Property extends Eloquent {

	protected $table = 'properties';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function property_type()
	{
		return $this->belongsTo('PropertyType', 'property_type_id');
	}

	public function room_type()
	{
		return $this->belongsTo('RoomType', 'room_type_id');
	}

	public function features()
	{
		return $this->hasMany('PropertyFeature', 'property_feature_id');
	}

	public function amenites()
	{
		return $this->hasMany('PropertyAmenity', 'property_id');
	}

	public function images()
	{
		return $this->hasMany('PropertyHasImages', 'property_id');
	}

	public function infoes()
	{
		return $this->hasMany('PropertyInfo', 'property_id');
	}

	public function rules()
	{
		return $this->hasMany('PropertyRule', 'property_id');
	}

	public function checking_detail()
	{
		return $this->hasOne('PropertyCheckinDetail', 'property_id');
	}

	public function bloking_dates()
	{
		return $this->hasMany('PropertyBlockingDates', 'property_id');
	}

	public function address()
	{
		return $this->hasOne('App\Models\PropertyAddresses', 'property_id');
	}

	public function bokking_availability()
	{
		return $this->hasOne('App\Models\PropertyBookingAvailability', 'property_id');
	}

	public function rejection_reason()
	{
		return $this->hasMany('App\Models\PropertyRejectionReasons', 'property_id');
	}

}