<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RoomType extends Eloquent {

	protected $table = 'room_types';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function features()
	{
		return $this->hasMany('App\Models\PropertiesFeature', 'room_type_id');
	}

	public function property_type()
	{
		return $this->belongsTo('App\Models\PropertyType', 'property_type_id');
	}

}