<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyRulesTable extends Migration {

	public function up()
	{
		Schema::create('property_rules', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('property_id')->unsigned();
			$table->bigInteger('rule_id')->unsigned();
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('property_rules');
	}
}