<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('first_name', 100);
			$table->string('last_name', 100);
			$table->enum('gender', array('m', 'f', 'o'))->nullable();
			$table->string('email', 255)->unique();
			$table->string('contact_number', 20)->nullable();
			$table->date('birth_date')->nullable();
			$table->string('password', 255)->nullable();
			$table->string('two_factor_code', 4)->nullable();
			$table->datetime('two_factor_expires_at')->nullable();
			$table->string('profile_pic', 100)->nullable();
			$table->enum('type', array('customer', 'host', 'admin'))->default('customer');
			$table->string('social_id', 2000)->nullable();
			$table->enum('social_type', array('fb', 'google', 'apple', 'normal'))->default('normal');
			$table->timestamps();
			$table->softDeletes();
			$table->string('stripe_id', 255)->nullable();
			$table->boolean('is_document_verify')->nullable();
			$table->string('fcm_token', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}