<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTravelcardsTable extends Migration {

	public function up()
	{
		Schema::create('travelcards', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('code', 14);
			$table->date('date');
			$table->integer('shift');
			$table->bigInteger('plan_id')->unsigned();
			$table->integer('line');
			$table->integer('tumble');
			$table->bigInteger('product_id')->unsigned();
			$table->bigInteger('size_id')->unsigned();
			$table->bigInteger('surface_id')->unsigned();
			$table->bigInteger('color_id')->unsigned();
			$table->bigInteger('weight_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('travelcards');
	}
}