<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Attendees extends Eloquent {

	protected $table = 'attendees';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'mall_id', 'employee_id', 'date', 'type');

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

}