<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Bonus extends Eloquent {

	protected $table = 'bonus';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('account_id', 'country_id', 'mall_id', 'employee_id', 'type_id', 'amount', 'date', 'status', 'notes_en', 'notes_ar');

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

	public function type()
	{
		return $this->belongsTo('BonusType', 'type_id');
	}

	public function account()
	{
		return $this->belongsTo('Account', 'account_id');
	}

}