<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Custody extends Eloquent {

	protected $table = 'custody';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'mall_id', 'employee_id', 'category_id', 'data_id', 'notes_en', 'notes_ar', 'number', 'date', 'status');

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

	public function category()
	{
		return $this->belongsTo('CustodyCategory', 'category_id');
	}

	public function data()
	{
		return $this->belongsTo('CustodyData', 'data_id');
	}

}