<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CustodyData extends Eloquent {

	protected $table = 'custody_data';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_en', 'name_ar', 'category_id');

	public function category()
	{
		return $this->belongsTo('CustodyCategory', 'category_id');
	}

}