<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CustodyMovement extends Eloquent {

	protected $table = 'custody_movement';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('custody_id', 'date', 'movement');

	public function custody()
	{
		return $this->belongsTo('Custody', 'custody_id');
	}

}