<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Deduction extends Eloquent {

	protected $table = 'deduction';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('account_id', 'country_id', 'mall_id', 'employee_id', 'type_id', 'amount', 'date', 'status', 'notes_en', 'notes_ar');

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

	public function type()
	{
		return $this->belongsTo('DeductionType', 'type_id');
	}

	public function account()
	{
		return $this->belongsTo('Account', 'account_id');
	}

}