<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EmployeeDeduction extends Eloquent {

	protected $table = 'employee_deduction';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'mall_id', 'type_id', 'employee_id', 'amount', 'calculation_method');

	public function type()
	{
		return $this->belongsTo('EmployeeDeductionType', 'type_id');
	}

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

}