<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class EmployeeTermination extends Eloquent {

	protected $table = 'employee_termination';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'mall_id', 'employee_id', 'reason_id', 'date', 'bonus', 'notes_en', 'notes_ar');

	public function reason()
	{
		return $this->belongsTo('ReasonToLeave', 'reason_id');
	}

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

}