<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payroll extends Eloquent {

	protected $table = 'payroll';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'mall_id', 'account_id', 'month', 'year', 'employee_number', 'total', 'payment_date', 'description_en', 'description_ar');

	public function account()
	{
		return $this->belongsTo('Account', 'account_id');
	}

}