<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PayrollEmployee extends Eloquent {

	protected $table = 'payroll_employee';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'mall_id', 'employee_id', 'payroll_id', 'main_salary', 'allowances', 'deductions', 'bonus', 'total');

	public function payroll()
	{
		return $this->belongsTo('Payroll', 'payroll_id');
	}

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

}