<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Receipt extends Eloquent {

	protected $table = 'receipt';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'mall_id', 'employee_id', 'account_id', 'type', 'date', 'amount', 'allocate', 'allocate_id');

	public function account()
	{
		return $this->belongsTo('Account', 'account_id');
	}

	public function employee()
	{
		return $this->belongsTo('Employee', 'employee_id');
	}

}