<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Transaction extends Eloquent {

	protected $table = 'transaction';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'mall_id', 'date', 'account_id', 'type', 'description_en', 'description_ar', 'debit', 'credit', 'balance');

	public function account()
	{
		return $this->belongsTo('Account', 'account_id');
	}

}