<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountTable extends Migration {

	public function up()
	{
		Schema::create('account', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('type_id')->nullable();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->double('balance')->nullable();
			$table->double('initial_balance')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('account');
	}
}