<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVacationTable extends Migration {

	public function up()
	{
		Schema::create('vacation', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->string('mall_id')->nullable();
			$table->integer('employee_id')->nullable();
			$table->integer('type_id')->nullable();
			$table->datetime('start_at')->nullable();
			$table->datetime('end_at')->nullable();
			$table->enum('status', array('accepted', 'refused', 'on_review'))->nullable();
			$table->datetime('application_date')->nullable();
			$table->double('amount')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('vacation');
	}
}