<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('order_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_id')->unsigned()->nullable();
			$table->tinyInteger('level')->unsigned();
			$table->integer('position')->unsigned()->nullable();
			$table->string('name');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_categories');
	}
}