<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('group', function(Blueprint $table) {
			$table->foreign('teacher_id')->references('id')->on('teacher')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('day_subject', function(Blueprint $table) {
			$table->foreign('day_id')->references('id')->on('days')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('day_subject', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subject')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('class_table_subject', function(Blueprint $table) {
			$table->foreign('class_id')->references('id')->on('class_table')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('class_table_subject', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subject')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_subject', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('group')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_subject', function(Blueprint $table) {
			$table->foreign('subject_id')->references('id')->on('subject')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_student', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('group_student', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('group', function(Blueprint $table) {
			$table->dropForeign('group_teacher_id_foreign');
		});
		Schema::table('day_subject', function(Blueprint $table) {
			$table->dropForeign('day_subject_day_id_foreign');
		});
		Schema::table('day_subject', function(Blueprint $table) {
			$table->dropForeign('day_subject_subject_id_foreign');
		});
		Schema::table('class_table_subject', function(Blueprint $table) {
			$table->dropForeign('class_table_subject_class_id_foreign');
		});
		Schema::table('class_table_subject', function(Blueprint $table) {
			$table->dropForeign('class_table_subject_subject_id_foreign');
		});
		Schema::table('group_subject', function(Blueprint $table) {
			$table->dropForeign('group_subject_group_id_foreign');
		});
		Schema::table('group_subject', function(Blueprint $table) {
			$table->dropForeign('group_subject_subject_id_foreign');
		});
		Schema::table('group_student', function(Blueprint $table) {
			$table->dropForeign('group_student_student_id_foreign');
		});
		Schema::table('group_student', function(Blueprint $table) {
			$table->dropForeign('group_student_group_id_foreign');
		});
	}
}