<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogPostsTable extends Migration {

	public function up()
	{
		Schema::create('blog_posts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title');
			$table->string('content');
			$table->bigInteger('user_id')->unsigned();
			$table->text('excerpt');
			$table->enum('status', array(''));
			$table->string('featured_image');
			$table->boolean('approved');
		});
	}

	public function down()
	{
		Schema::drop('blog_posts');
	}
}