<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('PostCategories', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('blog_posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('PostCategories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('Categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('PostRelateds', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('blog_posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('PostRelateds', function(Blueprint $table) {
			$table->foreign('related_post_id')->references('id')->on('blog_posts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->dropForeign('blog_posts_user_id_foreign');
		});
		Schema::table('PostCategories', function(Blueprint $table) {
			$table->dropForeign('PostCategories_post_id_foreign');
		});
		Schema::table('PostCategories', function(Blueprint $table) {
			$table->dropForeign('PostCategories_category_id_foreign');
		});
		Schema::table('PostRelateds', function(Blueprint $table) {
			$table->dropForeign('PostRelateds_post_id_foreign');
		});
		Schema::table('PostRelateds', function(Blueprint $table) {
			$table->dropForeign('PostRelateds_related_post_id_foreign');
		});
	}
}