<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactUsTable extends Migration {

	public function up()
	{
		Schema::create('contact_us', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->string('email')->nullable();
			$table->string('mobile')->nullable();
			$table->string('country_code')->nullable();
			$table->enum('type', array('suggest', 'problem', 'report', 'other'))->nullable();
			$table->text('message')->nullable();
			$table->enum('read', array('true', 'false'))->nullable();
			$table->string('reply')->nullable();
			$table->timestamp('reply_time')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('contact_us');
	}
}