<?php

namespace App\Models;

class DiscoverItem extends Eloquent {

	protected $table = 'discover_items';
	public $timestamps = true;
	protected $fillable = array('category_id', 'title', 'country_id', 'city_id');

	public function category()
	{
		return $this->belongsTo('DiscoverCategory', 'category_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function city()
	{
		return $this->belongsTo('Country', 'city_id');
	}

}