<?php

namespace App\Models;

class Event extends Eloquent {

	protected $table = 'events';
	public $timestamps = true;
	protected $fillable = array('title', 'lat', 'lng', 'country_id', 'city_id', 'duration_days', 'event_type_id', 'description');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function city()
	{
		return $this->belongsTo('Country', 'city_id');
	}

	public function type()
	{
		return $this->belongsTo('EventType', 'event_type_id');
	}

	public function images()
	{
		return $this->hasMany('Event', 'event_id');
	}

}