<?php

namespace App\Models;

class Service extends Eloquent {

	protected $table = 'services';
	public $timestamps = true;
	protected $fillable = array('type', 'title', 'service_category_id', 'duration', 'guide_id', 'price', 'persons', 'description', 'address', 'target_group', 'main_image', 'country_id', 'city_id', 'area_id', 'children', 'children_age', 'feature', 'start_time', 'has_offer', 'admin_approve', 'lat', 'lng', 'currency', 'date_start', 'time_start', 'date_end', 'time_end');
	protected $visible = array('type');

	public function guide()
	{
		return $this->belongsTo('User', 'guide_id');
	}

	public function category()
	{
		return $this->belongsTo('ServiceCategory', 'service_category_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function city()
	{
		return $this->belongsTo('Country', 'city_id');
	}

	public function area()
	{
		return $this->belongsTo('Country', 'area_id');
	}

	public function images()
	{
		return $this->hasMany('ServiceImage', 'service_id');
	}

	public function attachments()
	{
		return $this->belongsToMany('Attachment', 'service_attachments', 'service_id', 'attachment_id');
	}

	public function regiments()
	{
		return $this->hasMany('Regimet', 'service_id');
	}

	public function service_offers()
	{
		return $this->hasMany('ServiceOffer', 'service_id');
	}

}