<?php

namespace App\Models;

class SuggestService extends Eloquent {

	protected $table = 'suggested_services';
	public $timestamps = true;
	protected $fillable = array('guide_name', 'guide_image', 'guide_number', 'guide_id', 'country_id', 'city_id', 'lat', 'lng', 'description');

	public function guide()
	{
		return $this->belongsTo('User', 'guide_id');
	}

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

	public function city()
	{
		return $this->belongsTo('Country', 'city_id');
	}

}