<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSuggestedServicesTable extends Migration {

	public function up()
	{
		Schema::create('suggested_services', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('guide_name')->nullable();
			$table->string('guide_image')->nullable();
			$table->string('guide_number')->nullable();
			$table->integer('guide_id')->unsigned();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('city_id')->unsigned()->nullable();
			$table->string('lat')->nullable();
			$table->string('lng')->nullable();
			$table->text('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('suggested_services');
	}
}