<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('twitter')->nullable();
			$table->string('whatsapp')->nullable();
			$table->string('instagram')->nullable();
			$table->string('sanp')->nullable();
			$table->string('youtube')->nullable();
			$table->longText('about')->nullable();
			$table->string('normal_commission')->nullable();
			$table->string('customized_trips_commission')->nullable();
			$table->string('cancel_discount')->nullable();
			$table->string('accepted_hours')->nullable();
			$table->string('cancel_hours')->nullable();
			$table->longText('client_terms')->nullable();
			$table->longText('guide_terms');
			$table->string('customized_trips_offer_hours')->nullable();
			$table->string('accepted_customized_hours')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}