<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletChargesTable extends Migration {

	public function up()
	{
		Schema::create('wallet_charges', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->enum('payment_type', array('visa', 'masterCard', 'applePay', 'mada', 'stcPay'))->nullable();
			$table->string('amount')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('wallet_charges');
	}
}