<?php

namespace Jiri;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Score extends Model 
{

    protected $table = 'scores';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'implementation_id', 'score', 'comment');

    public function meeting()
    {
        return $this->belongsTo('Impression');
    }

    public function implementation()
    {
        return $this->belongsTo('Implementation');
    }

}