<?php

namespace Jiri;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'company', 'is_admin', 'token');

    public function meetings()
    {
        return $this->hasMany('Impression');
    }

    public function events()
    {
        return $this->hasMany('Jiri');
    }

}