<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateImplementationsTable extends Migration {

	public function up()
	{
		Schema::create('implementations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('project_id')->unsigned();
			$table->integer('student_id')->unsigned();
			$table->integer('jiri_id')->unsigned();
			$table->string('url_project');
			$table->string('url_repo');
			$table->decimal('weight')->default('0');
			$table->decimal('mean_score')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('implementations');
	}
}