<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Performance extends Eloquent {

	protected $table = 'performances';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('calculated_score', 'manual_score', 'student_id', 'jiri_id');

	public function student()
	{
		return $this->belongsTo('Student');
	}

	public function event()
	{
		return $this->belongsTo('Jiri');
	}

}