<?php

namespace Jiri;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Project extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description');

	public function implementations()
	{
		return $this->hasMany('Implementation');
	}

	public function events()
	{
		return $this->belongsToMany('Jiri')->withPivot('weights');
	}

}