<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserSkillsTable extends Migration {

	public function up()
	{
		Schema::create('user_skills', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned()->nullable()->index();
			$table->integer('skill_id')->unsigned()->index();
			$table->integer('capacity')->nullable();
			$table->tinyInteger('is_secondary')->nullable()->index()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('user_skills');
	}
}