<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Team extends Eloquent {

	protected $table = 'teams';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('team_name', 'parent_team_id');
	protected $visible = array('team_name', 'parent_team_id');

	public function parentTeam()
	{
		return $this->belongsTo('App\Models\Team', 'parent_team_id');
	}

	public function users()
	{
		return $this->belongsToMany('App\Models\User', 'user_teams', 'team_id', 'user_id', 'id');
	}

}