<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserTeam extends Eloquent {

	protected $table = 'user_teams';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'team_id', 'is_supervisor');
	protected $visible = array('user_id', 'team_id', 'is_supervisor');

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'user_id');
	}

	public function team()
	{
		return $this->belongsTo('App\Models\Team', 'team_id');
	}

}