<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('device_code')->references('id')->on('devices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('daily_sales', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('stand_id')->references('id')->on('stands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('check_ins', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('check_ins', function(Blueprint $table) {
			$table->foreign('device_code')->references('id')->on('devices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stands', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stands', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_device_code_foreign');
		});
		Schema::table('daily_sales', function(Blueprint $table) {
			$table->dropForeign('daily_sales_user_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_stand_id_foreign');
		});
		Schema::table('check_ins', function(Blueprint $table) {
			$table->dropForeign('check_ins_user_id_foreign');
		});
		Schema::table('check_ins', function(Blueprint $table) {
			$table->dropForeign('check_ins_device_code_foreign');
		});
		Schema::table('stands', function(Blueprint $table) {
			$table->dropForeign('stands_category_id_foreign');
		});
		Schema::table('stands', function(Blueprint $table) {
			$table->dropForeign('stands_user_id_foreign');
		});
	}
}