<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHomeworkTable extends Migration {

	public function up()
	{
		Schema::create('homework', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('content')->nullable();
			$table->bigInteger('stage_id')->unsigned()->nullable();
			$table->string('image')->nullable();
			$table->string('teacher_name', 100)->nullable();
			$table->string('material', 100)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('homework');
	}
}