<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentTable extends Migration {

	public function up()
	{
		Schema::create('Student', function(Blueprint $table) {
			$table->increments('id');
			$table->string('Matricule')->unique();
			$table->string('FirstName', 100)->default('FirstName');
			$table->string('LastName');
			$table->datetime('DateOfBirth');
			$table->string('PlaceOfBirth', 100);
			$table->string('Sex', 10);
			$table->string('MobilePhone', 50);
			$table->string('Picture');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Student');
	}
}