<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'Users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function profile()
    {
        return $this->hasOne('\Profile');
    }

    public function addresses()
    {
        return $this->hasMany('UserAddress');
    }

}