<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateThirdCoefficientsTable extends Migration {

	public function up()
	{
		Schema::create('third_coefficients', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('brand_id')->unsigned();
			$table->integer('third_base_id')->unsigned();
			$table->double('1_2')->nullable();
			$table->double('2_5')->nullable();
			$table->double('5_5')->nullable();
			$table->boolean('is_active')->default(1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('third_coefficients');
	}
}