<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateThirdBaseTable extends Migration {

	public function up()
	{
		Schema::create('third_base', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('car_usage_id');
			$table->string('name');
			$table->string('count_type');
			$table->string('slug')->nullable();
			$table->double('base_third_party')->nullable();
			$table->double('base_driver_accident')->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('third_base');
	}
}