<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFiresTable extends Migration {

	public function up()
	{
		Schema::create('fires', function(Blueprint $table) {
			$table->increments('id');
			$table->text('description')->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('brand_id')->unsigned();
			$table->double('airplane')->nullable();
			$table->double('earthquake')->nullable();
			$table->double('pipe')->nullable();
			$table->double('tornado')->nullable();
			$table->double('flood')->nullable();
			$table->double('steal')->nullable();
			$table->double('rain')->nullable();
			$table->double('electricity')->nullable();
			$table->integer('bricks')->default('1');
			$table->integer('concrete')->default('1');
			$table->integer('metal')->default('1');
			$table->integer('fire_rate')->default('0');
			$table->integer('earthquake_rate')->default('0');
			$table->double('discount_manager_percent');
			$table->double('discount_manager_amount');
			$table->tinyInteger('installments')->default('0');
			$table->double('installment_percent')->default('0');
			$table->integer('short_term')->default('0');
			$table->double('shortterm_before')->nullable();
			$table->integer('sum_discount');
			$table->tinyInteger('round_it')->default('1');
			$table->double('tax')->default('9');
			$table->integer('position')->default('1000');
			$table->boolean('is_active')->default(1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('fires');
	}
}