<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateThirdFinancesTable extends Migration {

	public function up()
	{
		Schema::create('third_finances', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('third_base_id')->unsigned();
			$table->integer('brand_id')->unsigned();
			$table->double('price')->nullable();
			$table->double('percent')->nullable();
			$table->double('commitment')->nullable();
			$table->tinyInteger('is_active')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('third_finances');
	}
}