<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerBalanceTable extends Migration {

	public function up()
	{
		Schema::create('customer_balance', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('customer_id')->unsigned();
			$table->decimal('amount')->default('0');
			$table->tinyInteger('flow_status');
			$table->decimal('balance')->default('0');
			$table->text('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customer_balance');
	}
}