<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVctOnDemandsTable extends Migration {

	public function up()
	{
		Schema::create('vct_on_demands', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('customer_id')->unsigned();
			$table->integer('hospital_id')->unsigned()->nullable();
			$table->integer('hospital_vct_staff_id')->unsigned()->nullable();
			$table->datetime('date_order');
			$table->text('address_detail')->nullable();
			$table->float('latitude')->nullable();
			$table->float('longitude')->nullable();
			$table->tinyInteger('status_order')->nullable();
			$table->date('checkup_date')->nullable();
			$table->time('checkup_time')->nullable();
			$table->decimal('price')->nullable();
			$table->decimal('tax')->nullable();
			$table->tinyInteger('payment_status')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('vct_on_demands');
	}
}