<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('hospital_id')->references('id')->on('hospitals')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vct_on_demands', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vct_on_demands', function(Blueprint $table) {
			$table->foreign('hospital_id')->references('id')->on('hospitals')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vct_on_demands', function(Blueprint $table) {
			$table->foreign('hospital_vct_staff_id')->references('id')->on('hospital_vct_staffs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('hospital_vct_staffs', function(Blueprint $table) {
			$table->foreign('hospital_id')->references('id')->on('hospitals')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('customer_balance', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_hospital_id_foreign');
		});
		Schema::table('vct_on_demands', function(Blueprint $table) {
			$table->dropForeign('vct_on_demands_customer_id_foreign');
		});
		Schema::table('vct_on_demands', function(Blueprint $table) {
			$table->dropForeign('vct_on_demands_hospital_id_foreign');
		});
		Schema::table('vct_on_demands', function(Blueprint $table) {
			$table->dropForeign('vct_on_demands_hospital_vct_staff_id_foreign');
		});
		Schema::table('hospital_vct_staffs', function(Blueprint $table) {
			$table->dropForeign('hospital_vct_staffs_hospital_id_foreign');
		});
		Schema::table('customer_balance', function(Blueprint $table) {
			$table->dropForeign('customer_balance_customer_id_foreign');
		});
	}
}